/*
 *	Hewlett-Packard Co., High Performance Systems Division
 *
 *	Function:	- example: simple "hello world"
 *
 *	$Revision: 1.1.2.1 $
 */

#include <stdio.h>
#include <mpi.h>

main(argc, argv)

int			argc;
char			*argv[];

{
	int		rank, size, len;
	char            name[MPI_MAX_PROCESSOR_NAME];
	int to_wait = 0, sleep_diff = 0, max_limit = 0;
        double sleep_start = 0.0, sleep_now = 0.0;

	MPI_Init(&argc, &argv);
	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	MPI_Comm_size(MPI_COMM_WORLD, &size);
	
	MPI_Get_processor_name(name, &len);

	if (argc > 1)
        {
                to_wait = atoi(argv[1]);
        }

	//busy loop for debuging needs
	if (to_wait)
	{	
    		sleep_start=MPI_Wtime();
    		while(1)
    		{
        		max_limit++;
        		if(max_limit > 100000000)
        		{
                		fprintf(stdout,"--------  exit loop, to_wait: %d, \n", to_wait);
                		break;
        		}
                                                                                                                            
        		sleep_now = MPI_Wtime();
        		sleep_diff = (int)(sleep_now - sleep_start);
        		if(sleep_diff >= to_wait)
        		{
                		break;
        		}
    		}
	}

	if (rank == 0) //only the first will print this message
	{
		printf ("Hello world! I'm %d of %d on %s\n", rank, size, name);
	}

	MPI_Finalize();
	exit(0);
}
